# Flutter Example: Aerodynamic model
#
#   - Create the aerodynamic component
#
# ----------------------------------------------------------------

  fid = fopen("aero.res", "wt");

# Model definition
# ----------------

  parameters

  aero_model = struct("type", "aero", "subtype", "vlm",
                      "symy",      0, "cref",       cr);
  
# Points on leading edge

  xtm = param.b * tand(param.sweep);

  points = struct("id", {1, 2},
                  "coor", {[-0.5 * cr, 0, 0], ...
                           [xtm - 0.5 * ct, param.b, 0]});
  aero_model.points = points;

# Lifting surface

  aero_model.ls = struct("id", 1, "points", [1, 2], 
                         "chord", [cr, ct], "nx", nx, 
                         "ny", ny, "typey", "cos>");

# Analysis
# --------

# Create and export component

  winga = mfs_new(fid, aero_model);
  mfs_export("aero.msh", "msh", winga, "mesh");

  save -binary aero.bin winga

  fclose(fid);
