# Flutter Example: Aeroelastic model
#
#  - Create the aeroelastic component
#  - Check the splines using the normal modes
#
# Files needed:  solid.bin from modes.m
#                aero.bin  from aero.m
#
# ----------------------------------------------------------------

  fid = fopen("aeroelastic.res", "wt");

# Model definition
# ----------------

  parameters

  load solid.bin
  load aero.bin

  aeroelastic_model = struct("type", "aeroelastic",
                             "solid", wings, "aero", winga);

# Splines

  spldata = struct("nbreaks", nbreaks);
  aeroelastic_model.splines = struct("id", 1, "type", "tb", 
                                     "lsid", 1, "data", spldata);

# Analysis
# --------

  wing = mfs_new(fid, aeroelastic_model);
  wing = mfs_splines(wing);

  save -binary aeroelastic.bin wing

  winga = mfs_transfer(wing, wings, "modes", "disp");
  mfs_export("aero.modes", "msh", winga, "modes", "disp");

  mfs_merge("solid.msh", "aero.msh", "wing.msh", "msh");
  mfs_merge("solid.modes", "aero.modes", "wing.modes", "msh");

  fclose(fid);
