# Flutter Example: Flutter analysis using the pk-method
#
# File needed: aeroelastic.bin from aeroelastic.m
#
# ----------------------------------------------------------------

  fid  = fopen("flutter_pk.res", "wt");

# Data

  parameters

  v    =  60 : 0.1 : 62;    % Velocities (in m/s)
  pairs = 1 : 5;            % Mode pairs to iterate on

  v = 1000 * v;             % Velocities in mm/s

# Load aeroelastic component

  load aeroelastic.bin

# Flutter analysis

  wing = mfs_flutter(wing, v, rho, "pk", pairs);
  save -binary flutter_pk.bin wing

  mfs_print(fid, wing, "flutter", "curves");

  fclose(fid);
