# Flutter Example: Solid model
# 
#   - Create the solid component and compute the stiffness
#     and mass matrix
#   - Compute normal modes
#
# ----------------------------------------------------------------

  fid = fopen("modes.res", "wt");

# Model definition
# ----------------

  parameters

# Translation data

  data = struct("type", "solid", "subtype", "3d");

  spar = struct("type", "elements", "name", "b2",
                "geom", spars_geom, "mat", mat);
  data.Front_Spar = spar;
  data.Rear_Spar  = spar;

  ribs = struct("type", "elements", "name", "b2",
                "geom", ribs_geom, "mat", mat);
  data.Ribs = ribs;

  connector = struct("type", "elements", "name", "b2",
                     "geom", connector_geom, "mat", mat);
  data.Connector = connector;

  data.Mass = struct("type", "elements", "name", "m1",
                     "geom", mass_geom);

  data.Constraints = struct("type", "constraints",
                            "name", "prescribed",
                            "dofs", 1 : 6);

# Analysis
# --------

# Import and translate model

  solid_model = mfs_import(fid, "solid.msh", "msh", data);

# Create and export component

  wings = mfs_new(fid, solid_model);
  mfs_export("solid.axes", "msh", wings, "mesh", "axes");

# Compute Stiffness and mass matrix

  wings = mfs_stiff(wings);
  wings = mfs_mass(wings);
  mfs_massproperties(fid, wings);

# Compute Normal modes

  wings = mfs_freevib(wings, nmodes);
  mfs_print(fid, wings, "modes", "freq");
  mfs_export("solid.modes", "msh", wings, "modes", "disp");
  mfs_export("solid.rot", "msh", wings, "modes", "rot");

  save -binary solid.bin wings

  fclose(fid);
