# Flutter-Example: Data definition
#
# Units: N, mm, t
#
# If this file is changed, run make_constants.m to update file
# constants.geo which is included by file solid.geo.
#
# ----------------------------------------------------------------

# Modal reduction

  nmodes = 15;          % Number of normal modes

# Geometry

  param.sweep =    10;  % Sweep angle in degrees
  param.b     = 10000;  % Half span
  param.dr    =  2000;  % Distance of spars at wing root
  param.dt    =  1000;  % Distance of spars at wing tip
  param.em    =   600;  % Distance of mass from trailing edge
  param.ns    =     5;  % Number of wing sections
  param.el    =   500;  % Element length

  cr          =  3000;  % Chord length at wing root
  ct          =  1500;  % Chord length at wing tip

# Material

  mat = struct("type", "iso", 
               "E",   70e3,       % Young's modulus
               "ny",  0.34,       % Poisson's ratio
               "rho", 2.7e-09);   % Mass density

# Mass at wing tip

  mass_geom = struct("m", 5.e-3);

# Cross section properties

  spars = struct("b", 200, "h", 200, "t", 1);
  spars_geom = mfs_beamsection("box", "thin", spars.b, spars.h, 
                               spars.t);
  spars_geom.v = [0, 0, 1];

  ribs = struct("b", 100, "h", 200, "t", 2, "s", 2);
  ribs_geom = mfs_beamsection("I", ribs.b, ribs.h, ribs.t,
                              ribs.s);
  ribs_geom.v = [0, 0, 1];

  connector = struct("b", 100, "h", 200, "t", 2, "s", 2);
  connector_geom = mfs_beamsection("I", connector.b, connector.h,
                                   connector.t, connector.s);
  connector_geom.v = [0, 0, 1];
  
# Discretization of lifting surface

  nx = 20;  % Number of panels in x-direction
  ny = 45;  % Number of panesl in y-direction 

# Mass density of air

  rho = 1.21e-12;

# Number of spline breaks

  nbreaks = 10;
