# Flutter Example: Postprocessing of results from k-method
#
# - plot flutter curves of first analysis
#
# ----------------------------------------------------------------

  addpath("../../..");
  [EXT, FORMAT] = iniplot();

  set(0, "defaultaxesfontsize", 10);

  modes = [1, 2, 3, 8, 11];      % selected flutter modes

  load flutter_k1.bin

  [v, g, kred, f] = mfs_getresp(wing, "flutter", "curves", modes);
  v = v / 1000;

  nofmod = length(modes);

  for n = 1 : nofmod
      ltext{n} = sprintf("Mode %2d", modes(n));
  endfor

  figure(1, "position", [50, 50, 700, 500],
            "paperposition", [0, 0, 17, 11]);
  subplot(2, 1, 1)
     plot(v, g, "marker", "o");
     legend(ltext, "location", "southeast");
     legend("numcolumns", 2);
     grid;
     axis("labely");
     xlim([0, 100]);
     ylabel('\gamma');
  subplot(2, 1, 2)
     plot(v, f, "marker", "o");
     grid;
     xlim([0, 100]);
     xlabel("v [m/s]"); ylabel("f [Hz]");
  print(["flutter_k1_v", EXT], FORMAT);

  figure(2, "position", [200,100, 700, 500],
            "paperposition", [0, 0, 17, 11]);
  subplot(2, 1, 1)
     plot(kred, g, "marker", "o");
     legend(ltext, "location", "southeast");
     legend("numcolumns", 2);
     grid;
     axis("labely");
     ylabel('\gamma');
  subplot(2, 1, 2)
     plot(kred, f, "marker", "o");
     grid;
     xlabel("k"); ylabel("f [Hz]");
  print(["flutter_k1_k", EXT], FORMAT);
