# Flutter Example: Postprocessing of results from k-method
#
# - plot flutter curves of second analysis
#
# ----------------------------------------------------------------

  addpath("../../..");
  [EXT, FORMAT] = iniplot();

  set(0, "defaultaxesfontsize", 10);

  mode = 2;      % selected flutter mode

  load flutter_k2.bin

  [v, g, kred, f] = mfs_getresp(wing, "flutter", "curves", mode);
  v = v / 1000;

  ltext = sprintf("Mode %2d", mode);

  figure(1, "position", [50, 50, 700, 500],
            "paperposition", [0, 0, 17, 11]);
  subplot(2, 1, 1)
     plot(v, g, "color", "red", "marker", "o");
     legend(ltext, "location", "northwest");
     grid; 
     xlim([55, 80]);
     xlabel("v [m/s]"); ylabel('\gamma');
  subplot(2, 1, 2)
     plot(kred, g, "color", "red", "marker", "o");
     grid;
     xlabel("k"); ylabel('\gamma');
  print(["flutter_k2", EXT], FORMAT);
