# Flutter Example: Postprocessing of results from pk-method
#
# - plot flutter curves
# - compute and export flutter shape
#
# ----------------------------------------------------------------

  addpath("../../..");
  [EXT, FORMAT] = iniplot();

  set(0, "defaultaxesfontsize", 10);

  modpnt = [3, 18];   % Flutter mode, flutter point

  ltext = sprintf("Mode %d", modpnt(1));

  load flutter_pk.bin

# Flutter curves

  [v, a, kred, f] = mfs_getresp(wing, "flutter", 
                                      "curves", modpnt(1));
  v = v / 1000;

  figure(1, "position", [50, 50, 1000, 500],
            "paperposition", [0, 0, 17, 11]);
  subplot(2, 1, 1)
     plot(v, a, "color", "red", "marker", "o");
     legend(ltext, "location", "northwest");
     grid;
     axis("labely");
     ylabel("a [1/s]");
  subplot(2, 1, 2)
     plot(v, f, "color", "red", "marker", "o");
     grid;
     xlabel("v [m/s]"); ylabel("f [Hz]");
  print(["flutter_pk", EXT], FORMAT);

# Back tranformation

  [wings, winga] = mfs_back(wing, "flutter", "disp", modpnt);

# Export

  mfs_export("solid_pk.dsp", "msh", wings, "flutter", "disp");
  mfs_export("aero_pk.dsp", "msh", winga, "flutter", "disp");

# Merge

  mfs_merge("solid_pk.dsp", "aero_pk.dsp", "wing_pk.dsp", "msh");
