/* -------------------------------------------------------------------
                            Simple Swept Wing

                                Units: mm
------------------------------------------------------------------- */

// Parameters

   Include "constants.geo";

   sweep = Tan(sw * Pi / 180);

// Points

   xr1  = -0.5 * cr;
   xr2  =  0.5 * cr;
   xtm  =  b * sweep; 
   xt1 =  xtm - 0.5 * ct;
   xt2  = xtm + 0.5 * ct;

   m1 = (xt1 - xr1) / b;
   m2 = (xt2 - xr2) / b;

   dy   = b / n;

   For k In {0 : n}
       y  = k * dy;
       x1 = xr1 + m1 * y;
       x2 = xr2 + m2 * y;
       Point(newp) = {x1, y, 0, el}; 
       Point(newp) = {x2, y, 0, el}; 
   EndFor

// Front Spar

   p1 = 1;
   For k In {1 : n}
       p2 = p1 + 2;
       Curve(newl) = {p1, p2};
       p1 = p2;
   EndFor

   Physical Curve("Front_Spar") = {1 : newl-1};

// Rear Spar

   l1 = newl;
   p1 = 2;
   For k In {1 : n}
       p2 = p1 + 2;
       Curve(newl) = {p1, p2};
       p1 = p2;
   EndFor

   Physical Curve("Rear_Spar") = {l1 : newl-1};

// Ribs

   l1 = newl;
   p1 = 1;
   p2 = 2;
   For k In {0 : n-1}
       Curve(newl) = {p1, p2};
       p1 += 2;
       p2 += 2;
   EndFor 
   
   Physical Curve("Ribs") = {l1 : newl-1};

// Outer beam with point mass

   coor = Point{12};
   pm   = newp;
   Point(pm) = {coor[0] + em, coor[1], coor[2], el};  

   l1 = newl;
   Curve(newl) = {11, 12}; Curve(newl) = {12, pm};

   Physical Curve("Connector") = {l1 : newl-1};
   Physical Point("Mass") = {pm};

// Constraints

   Physical Point("Constraints") = {1, 2};
