# Example: Frequency response analysis of a standard class glider
#          Transfer functions for response to elevator input
#          Files needed:  solid.bin, aero.bin, elevator.bin
#          Files created: trf.bin
# ---------------------------------------------------------------

  addpath("../models");    % Path to model definition

  fid  = fopen("trf.res", "wt");

# Data (kg, m, s)

  rho = 1.21;   % Mass density of the air
  eta =    1;   % Amplitude of elevator motion
  v   =   40;   % Flight velocity
  fc  =   10;   % Cut-off frequency

# Excitation frequencies

  load ../loads/elevator.bin
  f    = df : df : fc;

# Define aeroelastic model

  load ../models/solid.bin
  load ../models/aero.bin

  model = struct("type", "aeroelastic",
                 "solid", gliders, "aero", glidera,
                 "splines", splinedef());

# Define elevator motion

  model.loads.manoeuvre = struct("qdyn", 0.5 * rho * v^2,
                                 "v", v, 
                                 "elevator", eta);

# Build aeroelastic component and compute splines

  glider = mfs_new(fid, model);
  glider = mfs_splines(glider);

# Compute the transfer functions

  glider = mfs_freqresp(glider, f);

  save -binary trf.bin glider

  fclose(fid);
