# Example: Frequency response analysis of a standard class glider
#          Transfer functions for response to elevator input
#          Back transformation at selected frequencies
#          Files needed: trf.bin
# ---------------------------------------------------------------

# List of frequencies for back transformation

  fb = [2, 4];

# Load the aeroelastic component

  load trf.bin

# Back transformation for solid component

  gliders      = mfs_extract(glider, "solid");
  [gliders, f] = mfs_back(gliders, "freqresp", "disp", 1, fb);
  mfs_export("gliders.dsp", "msh", gliders, "freqresp", "disp");

# Back transformation for aerodynamic component

  glidera      = mfs_extract(glider, "aero");
  [glidera, f] = mfs_back(glidera, "freqresp", "disp", 1, fb);
  mfs_export("glidera.dsp", "msh", glidera, "freqresp", "disp");

# Combine results

  mfs_merge("gliders.dsp", "glidera.dsp", "glider.dsp", "msh");
