# Example: Frequency response analysis of a standard class glider
#          Transfer functions for response to elevator input
#          Files needed:  solid.bin, aero.bin
#          Files created: trfd.bin
#
#          Direct frequency response analysis, Rayleigh damping
#          required (use modes_rayleigh.m to create component)
#
# ---------------------------------------------------------------

  addpath("../models");    % Path to model definition

  fid  = fopen("trf_direct.res", "wt");

# Data (kg, m, s)

  rho = 1.21;   % Mass density of the air
  eta =    1;   % Amplitude of elevator motion
  v   =   40;   % Flight velocity
  fc  =   10;   % Cutoff frequency
  df  =  0.5;   % Frequency step

# Excitation frequencies

  f    = df : df : fc;

# Define aeroelastic model

  load ../models/solid.bin
  load ../models/aero.bin

  model = struct("type", "aeroelastic",
                 "solid", gliders, "aero", glidera,
                 "splines", splinedef());

# Define elevator motion

  model.loads.manoeuvre = struct("qdyn", 0.5 * rho * v^2,
                                 "v", v,
                                 "elevator", eta);

# Build aeroelastic component and compute splines

  glider = mfs_new(fid, model);
  glider = mfs_splines(glider);

# Compute the transfer functions

  gliderm = mfs_freqresp(glider, f);
  gliderd = mfs_freqresp(glider, f, "method", "direct");

  save -binary trf_direct.bin gliderm gliderd

  fclose(fid);
