# Example: Frequency response analysis of a standard class glider
#          Comparison of transfer functions from modal and direct
#          frequency response analysis
#          Files needed:  trfc.bin
# ---------------------------------------------------------------

  addpath("../../../..");
  [EXT, FORMAT] = iniplot();

  set(0, "defaultaxesfontsize", 10);

# Define response degrees of freedom

  rid = [5, 3; 15, 3; 115, 3];   % Node, Dof

# Load the aeroelastic component

  load trf_direct.bin

# Results from modal frequency response analysis

  gliderm = mfs_extract(gliderm, "solid");

  f  = mfs_getresp(gliderm, "freqresp", "freq");
  Um = mfs_getresp(gliderm, "freqresp", "disp", rid);
  Am = mfs_getresp(gliderm, "freqresp", "acce", rid);

# Results from direct frequency response analysis

  gliderd = mfs_extract(gliderd, "solid");

  f  = mfs_getresp(gliderd, "freqresp", "freq");
  Ud = mfs_getresp(gliderd, "freqresp", "disp", rid);
  Ad = mfs_getresp(gliderd, "freqresp", "acce", rid);

# Plot the transfer functions

  figure(1, "position", [100, 200, 800, 800],
            "paperposition", [0, 0, 17, 10]);
     semilogy(f, abs(Um),
              f, abs(Ud), "marker", "o", "linestyle", "none");
     legend("WR", "Tail", "WT");
     grid;
     ylabel('|U_z| [m/°]'); xlabel("f [Hz]");
  print(["cmp_U", EXT], FORMAT);

  figure(2, "position", [300, 200, 800, 800],
            "paperposition", [0, 0, 17, 10]);
     semilogy(f, abs(Am),
              f, abs(Ad), "marker", "o", "linestyle", "none");
     legend("WR", "Tail", "WT");
     grid;
     ylabel('|A_z| [(m/s^2)/°]'); xlabel("f [Hz]");
  print(["cmp_A", EXT], FORMAT);
