# Example: Frequency response analysis of a standard class glider
#          Gust response: Transform results of second gust to
#                         time domain and export displacements
#                         for movie
#          Files needed:  trf.bin, gust.bin, response.bin
# ---------------------------------------------------------------

# Define response degrees of freedom

  rid = [5, 3; 15, 3; 115, 3];   % Node, Dof

# Parameters of transient response

  dt = 0.010;   % Time step for transformation to time domain
  te =     2;   % Time for plotting and animation

# Get solid component with frequency response

  load trf.bin
  gliders = mfs_extract(glider, "solid");
  clear glider

# Get Fourier transforms of the gusts

  load ../loads/gust.bin

# Inverse Fourier transform for second gust and second velocity

  spectrum = struct("df", df, "lc", 2, 
                    "spec", W{2}(2, :));

  gliders = mfs_freq2time(gliders, spectrum, 1, dt);  

# Plot time history (for comparison with response.m)

  load response.bin
  ur = u{2, 2};

  tm = mfs_getresp(gliders, "transresp", "time");
  um = mfs_getresp(gliders, "transresp", "disp", rid);

  figure(1, "position", [100, 100, 1000, 800]);
  subplot(3, 1, 1);
     plot(t, ur(1, :), tm, um(1, :))
     title(sprintf("Node %3.0d", rid(1, 1)));
     legend("response", "motion");
     grid;
     xlim([0, te]);
     ylabel('u_z [m]'); 
  subplot(3, 1, 2);
     plot(t, ur(2, :), tm, um(2, :))
     title(sprintf("Node %3.0d", rid(2, 1)));
     grid;
     xlim([0, te]);
     ylabel('u_z [m]'); 
  subplot(3, 1, 3);
     plot(t, ur(3, :), tm, um(3, :))
     title(sprintf("Node %3.0d", rid(3, 1)));
     grid;
     xlim([0, te]);
     xlabel("t [s]"); ylabel('u_z [m]'); 

# Perform backtransformation and export displacements

  tb = t(find(tm <= te));
  gliders = mfs_back(gliders, "transresp", "disp", 1, tb);
  mfs_export("gust2.dsp", "msh", gliders, "transresp", "disp");
