# Example: Frequency response analysis of a standard class glider
#          Transfer functions for gust response
#          Files needed:  solid.bin, aero.bin, gust.bin
#          Files created: trf.bin
# ---------------------------------------------------------------

  addpath("../models");    % Path to model definition

  fid  = fopen("trf.res", "wt");

# Data (kg, m, s)

  rho =     1.21;   % Mass density of the air
  w0  =        1;   % Gust amplitude
  v   = [30, 60];   % Flight velocities
  fc  =       10;   % Cut-off frequency

# Excitation frequencies

  load ../loads/gust.bin
  f    = df : df : fc;

# Define aeroelastic model

  load ../models/solid.bin
  load ../models/aero.bin

  model = struct("type", "aeroelastic",
                 "solid", gliders, "aero", glidera,
                 "splines", splinedef());

# Define gusts

  qdyn = mat2cell(0.5 * rho * v.^2, 1, [1, 1]);

  model.loads.gust = struct("wg",   w0,
                            "v" ,   mat2cell(v, 1, [1, 1]),
                            "qdyn", qdyn,
                            "lc",   {1, 2});

# Build aeroelastic component and compute splines

  glider = mfs_new(fid, model);
  glider = mfs_splines(glider);

# Compute the transfer functions

  glider = mfs_freqresp(glider, f, "loadcase", 1);
  glider = mfs_freqresp(glider, f, "loadcase", 2);

  save -binary trf.bin glider

  fclose(fid);
