# Example: Frequency response analysis of a standard class glider
#          Fourier transform of the elevator input
#          Fourier transforms are stored in file elevator.bin.
# ---------------------------------------------------------------

  addpath("../../../..");
  [EXT, FORMAT] = iniplot();

  set(0, "defaultaxesfontsize", 10);

# Data of elevator input (degrees, s)

  eta0 =      5;    % Amplitude of elevator angle
  T0   =    1.0;    % Duration of elevator motion
  dt   =   0.01;    % Time step
  T    = 5 * T0;    % Total duration

# Time series

  N  = T / dt;    % Length of time series

  t0  = 0 : (dt / T0) : 1;
  eta = eta0 * sin(2 * pi * t0).^3;

# Fourier transform

  ETA = dt * fft(eta, N);

  fmax = 1 / (2 * dt); df   = 1 / T;
  f    = 0 : df : fmax;
  nf   = length(f);

# Plot

  figure(1, "position", [400, 200, 800, 600],
            "paperposition", [0, 0, 17, 12]);
  subplot(2, 1, 1);
     plot(t0, eta, "color", "green");
     grid;
     xlabel("t/T_0"); ylabel('\eta_E [\deg]');
  subplot(2, 1, 2);
     plot(f, abs(ETA(1 : nf)), "color", "red");
     grid; xlim([0, 10]);
     xlabel("f [Hz]"); ylabel('|FT(\eta_E)| [\deg/Hz]');
  print(["elevator", EXT], FORMAT);

  save -binary elevator.bin df ETA
