# Example: Frequency response analysis of a standard class glider
#          Check the aerodynamic mesh and the splines
#          File needed:   solid.bin
#          Files created: aero.bin
# ---------------------------------------------------------------

  fid  = fopen("checks.res", "wt");

# Build aerodynamic component

  modela  = aero();
  glidera = mfs_new(fid, modela);
  mfs_export("aero.msh", "msh", glidera, "mesh");

  save -binary aero.bin glidera

# Define aeroelastic model

  load solid.bin

  model = struct("type", "aeroelastic",
                 "solid", gliders, "aero", glidera,
                 "splines", splinedef());

# Build aeroelastic component and compute splines

  glider = mfs_new(fid, model);
  glider = mfs_splines(glider);

# Transfer normal modes to aerodynamic model

  glidera = mfs_transfer(glider, gliders, "modes", "disp");
  mfs_export("aero.modes", "msh", glidera, "modes", "disp");

# Combine models and modes

  mfs_merge("solid.msh", "aero.msh", "glider.msh", "msh");
  mfs_merge("solid.modes", "aero.modes", "glider.modes", "msh");

  fclose(fid);
