# Example: Frequency response analysis of a standard class glider
#          Normal modes analysis
#          Results are stored in file solid.bin.
# ---------------------------------------------------------------

  fid  = fopen("modes.res", "wt");

# Number of normal modes

  nmodes = 15;

# Model definition

  model = solid();

# Create and export component

  gliders = mfs_new(fid, model);
  mfs_export("solid.msh", "msh", gliders, "mesh");

# Matrices

  gliders = mfs_stiff(gliders);
  gliders = mfs_mass(gliders);
  mfs_massproperties(fid, gliders);

# Normal modes

  gliders = mfs_freevib(gliders, nmodes);
  mfs_print(fid, gliders, "modes", "freq");
  mfs_export("solid.modes", "msh", gliders, "modes", "disp");

# Save data

  save -binary solid.bin gliders

  fclose(fid);
