function splines = splinedef()
#
# --------------------------------------------------------------------
#  Example: Frequency response analysis of a standard class glider
#           Spline definition
# --------------------------------------------------------------------

# Data

  nbw = 15;  % Number of wing spline breaks
  nbv =  3;  % Number of vertical stabilizer spline breaks
  nbh =  3;  % Number of horizontal stabilizer spline breaks

  data = struct("nbreaks", {nbw, nbv, nbh});

# Right and left wing splines

  splines(1 : 2) = struct("id",    {10, 20},
                          "type",  "tb",
                          "lsid",  {10 : 12, 20 : 22},
                          "data",  data(1),
                          "nodes", {"right_wing", "left_wing"});

# Vertical stabilizer

  splines(3) = struct("id",    30,
                      "type",  "tb",
                      "lsid",  [31, 32],
                      "data",  data(2),
                      "nodes", "vertical");

# Horizontal stabilizer

  splines(4) = struct("id",   40,
                      "type", "tb",
                      "lsid", [41, 42, 43, 44],
                      "data", data(3),
                      "nodes", "horizontal");

endfunction
