# Example: Gull wing
#
# Static divergence
#
# Files needed: aeroelastic.bin
#
# ---------------------------------------------------------------------

  fid = fopen("diverg.res", "wt");

  load aeroelastic.bin

  nofmod = 3;

# Analysis
# --------

  [wings, winga, nfound] = mfs_diverg(wing, nofmod);
  if (nfound)
     mfs_print(fid, winga, "diverg", "qdyn");
     qd = mfs_getresp(winga, "diverg", "qdyn", 1);
     vd = sqrt(2 * qd / rho) / 1000;
     fprintf(fid, "  vd = %7.2f m/s\n", vd);
  endif

  fclose(fid);
