# Example: Swept Wing
#
# Definition of all parameters
#
# Units: N, mm, t, degrees
#
# ---------------------------------------------------------------

# Geometry
# --------

  sweep =   -5;   % Sweep angle
  ya    = 5000;   % y-position of aileron
  yt    = 8000;   % y-position of wing tip
  cr    = 1200;   % Chord at wing root
  ct    =  800;   % Chord at wing tip

# Solid Model
# -----------

# Material: Aluminium

  E   =  70000;
  ny  =   0.34;
  rho = 2.7E-9;

# Cross Sections

  ribs = struct("b", 20, "h", 20, "t", 2);

  stringer = struct("b", {30, 50, 40, 20},
                    "h", {30, 40, 30, 20},
                    "t", { 2,  4,  4,  2});

# Sheet metal thicknesses

  t_spars = [1, 2, 2, 1];
  t_ribs  = 1;
  t_skin  = 1;

# Aerodynamic Model
# -----------------

# Geometry

  fr   = 0.2;   % Flap chord ratio
  atip =  -3;   % Rigging angle of incidence at wing tip

# Configurations

  alpha =      2; % Angle of attack
  eta   = [0, 2]; % Aileron deflection

# Discretization

  nxi   =   40;   % Panels in x-direction for inner wing
  nxo   =   32;   % Panels in x-direction for outer wing
  nxa   =    8;   % Panels in x-direction for aileron

  nyi   =   15;   % Panels in y-direction for inner wing
  nyo   =   15;   % Panels in y-direction for outer wing

# Wing Section Positions for Pressure Output

  ycoli = [1, floor(0.7 * nyi)]; % Inner wing
  ycolo = [3, floor(0.7 * nyo)]; % Outer wing

# Aeroelastic Model
# -----------------

  nsb   = 10;     % Number of spline breaks
