function [EXT, FORMAT] = iniplot()

# usage: [EXT, FORMAT] = iniplot()
#
# Input  none
#
# Output EXT    Extension of plot file
#        FORMAT Format of plot file
#
# The function initializes plotting.
#
# -------------------------------------------------------------------

# Default colors

  colors = [1,   0,   0;    % red
            0,   1,   0;    % green
            0,   0,   1;    % blue
            1,   0,   1;    % magenta
            1, 0.5, 0.5];   % brown
  set(0, "defaultaxescolororder", colors);

# Default plot file format

  if (isunix)
     DEVICE = "svg";
  else
     DEVICE = "png";
  endif
  FORMAT = ["-d", DEVICE];
  EXT    = [".", DEVICE];

endfunction
