/* -------------------------------------------------------------------
   Free vibrations of an arc
   2-dimensional model with membrane elements
------------------------------------------------------------------- */

// Dimensions [mm]

   DefineConstant [ h = 400,
                    b =  50,
                    r = 100 ];

// Meshing parameters

   nb = GetValue("Number of Elements over the Width?", 4);
   nh = Floor(nb * h / b + 0.5);
   na = Floor(nb * Pi * r / b + 0.5);

   Mesh.ElementOrder = 
   GetValue("Element Order: 1 = Linear, 2 = Quadratic?", 1);
   If (Mesh.ElementOrder == 2)
      Mesh.SecondOrderIncomplete =
      GetValue("Incomplete Order: 0 = no, 1 = yes?", 0);
   EndIf
   Mesh.RecombineAll =
   GetValue("Create Quadrangles: 0 = no, 1 = yes?", 1);
   Mesh.Smoothing = 1;

// Geometry

   R = r + b;

   Point(1) = {-R, 0, 0};
   Point(2) = {-r, 0, 0};
   Point(3) = {-r, h, 0};
   Point(4) = {-R, h, 0};

   Point(5) = {r, 0, 0};
   Point(6) = {R, 0, 0};
   Point(7) = {R, h, 0};
   Point(8) = {r, h, 0};

   Point(9) = {0, h, 0};
   
   Line(1) = {1, 2};
   Line(2) = {2, 3};
   Line(3) = {3, 4};
   Line(4) = {4, 1};

   Line(5) = {5, 6};
   Line(6) = {6, 7};
   Line(7) = {7, 8};
   Line(8) = {8, 5};

   Circle( 9) = {8, 9, 3};
   Circle(10) = {7, 9, 4};

   Line Loop(1) = {1, 2, 3, 4};
   Line Loop(2) = {5, 6, 7, 8};
   Line Loop(3) = {-3, -9, -7, 10};

   Plane Surface(1) = {1};
   Plane Surface(2) = {2};
   Plane Surface(3) = {3};

// Elements

   Physical Surface("Elements") = {1, 2, 3};

// Constraints

   Physical Line("Constraints") = {1, 5};

// Commands to generate structured mesh

   Transfinite Line{2, 4, 6, 8} = nh + 1;
   Transfinite Line{1, 3, 5, 7} = nb + 1;
   Transfinite Line{9, 10} = na + 1;

   Transfinite Surface{1, 2, 3};
