/* ---------------------------------------------------------------
   Cylindrical box
--------------------------------------------------------------- */

// Dimensions [mm]

   DefineConstant [ r =  2000,    // Radius
                    l = 10000 ];  // Length

// Meshing parameters

   DefineConstant [ nel = 40,    // Elements along length
                    nec = 40 ];  // Elements along circumference

   nel = GetValue("Number of elements along length?", nel);
   nec = GetValue("Number of elements along circumference?", nec);

   npcirc = Ceil(nec/8) + 1;     // Number of points per circle
   npx    = Ceil(0.2*nel) + 1;   // Number of points per dx

   Mesh.RecombineAll = 1;        // Quadrangles

/* ---------------------------------------------------------------
   Left and right cap
--------------------------------------------------------------- */

   a = 0.5 * r;
   b = 0.4 * r;

   Point(1) = {0, 0, 0};

// Points of inner surfaces of left cap

   Point(2) = {0, -b, -b};
   Point(3) = {0,  0, -a};
   Point(4) = {0,  b, -b};
   Point(5) = {0,  a,  0};
   Point(6) = {0,  b,  b};
   Point(7) = {0,  0,  a};
   Point(8) = {0, -b,  b};
   Point(9) = {0, -a,  0};

// Lines of inner surfaces of left cap

   Line(1)  = {2, 3};
   Line(2)  = {3, 1};
   Line(3)  = {1, 9};
   Line(4)  = {9, 2};
   Line(5)  = {3, 4};
   Line(6)  = {4, 5};
   Line(7)  = {5, 1};
   Line(8)  = {5, 6};
   Line(9)  = {6, 7};
   Line(10) = {7, 1};
   Line(11) = {7, 8};
   Line(12) = {8, 9};

// Inner surfaces of left cap

   Curve Loop(1) = {1, 2, 3, 4};
   Plane Surface(1) = {1};
   Curve Loop(2) = {5, 6, 7, -2};
   Plane Surface(2) = {2};
   Curve Loop(3) = {7, -10, -9, -8};
   Plane Surface(3) = {3};
   Curve Loop(4) = {3, -12, -11, 10};
   Plane Surface(4) = {4};

// Points on circumference of left cap

   phi = 0.25 * Pi;
   Point(10) = {0, 0, -r};
   For id In {10 : 16}
      Rotate {{1, 0, 0}, {0, 0, 0}, phi} { Duplicata { Point{id}; } }
   EndFor

// Arcs of left cap

   Circle(13) = {10, 1, 11};
   Circle(14) = {11, 1, 12};
   Circle(15) = {12, 1, 13};
   Circle(16) = {13, 1, 14};
   Circle(17) = {14, 1, 15};
   Circle(18) = {15, 1, 16};
   Circle(19) = {16, 1, 17};
   Circle(20) = {17, 1, 10};

// Radial lines of left cap

   Line(21) = {3, 10};
   Line(22) = {4, 11};
   Line(23) = {5, 12};
   Line(24) = {6, 13};
   Line(25) = {7, 14};
   Line(26) = {8, 15};
   Line(27) = {9, 16};
   Line(28) = {2, 17};

// Stiffeners of left cap

   left_curves = Curve{:};
   Physical Curve("Left_Stiffeners") = { left_curves[] };

// Outer surfaces of left cap

   Curve Loop(5) = {13, -22, -5, 21};
   Plane Surface(5) = {5};
   Curve Loop(6) = {14, -23, -6, 22};
   Plane Surface(6) = {6};
   Curve Loop(7) = {15, -24, -8, 23};
   Plane Surface(7) = {7};
   Curve Loop(8) = {16, -25, -9, 24};
   Plane Surface(8) = {8};
   Curve Loop(9) = {17, -26, -11, 25};
   Plane Surface(9) = {9};
   Curve Loop(10) = {18, -27, -12, 26};
   Plane Surface(10) = {10};
   Curve Loop(11) = {19, -28, -4, 27};
   Plane Surface(11) = {11};
   Curve Loop(12) = {20, -21, -1, 28};
   Plane Surface(12) = {12};

// Right cap

   Translate {l, 0, 0} { Duplicata { Surface{1 : 12}; } }

   curvids_caps = Curve{ : };
   surfids_caps = Surface{:};

   Physical Surface("Caps") = { surfids_caps[] };
   
   right_curves  = curvids_caps[];
   right_curves -= left_curves[];

   Physical Curve("Right_Stiffeners") = { right_curves[] };

   Transfinite Curve{ curvids_caps[] } = npcirc;

/* ---------------------------------------------------------------
   Frames
--------------------------------------------------------------- */

   dx  = 0.2 * l;

   For k In {1 : 4}
      Translate {k * dx, 0, 0} { Duplicata { Curve{13 : 20}; } }
   EndFor

   frameids  = Curve{:};
   frameids -= curvids_caps[];

   Physical Curve("Frames") = { frameids[] };

   Transfinite Curve{ frameids[] } = npcirc;

/* ---------------------------------------------------------------
   Stringers
--------------------------------------------------------------- */

   idca = Curve{:};

   Line(118) = { 16, 214};
   Line(119) = {214, 247};
   Line(120) = {247, 280};
   Line(121) = {280, 313};
   Line(122) = {313, 169};

   For k In {1 : 7}
      Rotate {{1, 0, 0}, {0, 0, 0}, k * phi} { 
        Duplicata { Curve{118 : 122}; } }
   EndFor

   stringerids  = Curve{:};
   stringerids -= idca[];

   Physical Curve("Stringers") = { stringerids[] };

   Transfinite Curve{ stringerids[] } = npx;

/* ---------------------------------------------------------------
   Skin
--------------------------------------------------------------- */

   Curve Loop(13) = {19, 123, -92, -118};
   Surface(85) = {13};

   For k In {1 : 7}
      Rotate {{1, 0, 0}, {0, 0, 0}, k * phi} { 
        Duplicata { Surface{85}; } }
   EndFor

   For k In {1 : 4}
      Translate {k * dx, 0, 0} { Duplicata { 
         Surface{85}; Surface{158 : 164}; } }
   EndFor

   skinids  = Surface{:};
   skinids -= surfids_caps[];

   Physical Surface("Skin") = { skinids[] };

/* ---------------------------------------------------------------
   Floor
--------------------------------------------------------------- */

   idca = Curve{:};
   idsa = Surface{:};

   Line(158) = {17, 11};
   Line(159) = {219, 189};
   Curve Loop(14) = {158, 133, -159, -123};
   Plane Surface(309) = {14};

   For k In {1 : 4}
      Translate {k * dx, 0, 0} { Duplicata { Surface{309}; } }
   EndFor

   floorids  = Surface{:};
   floorids -= idsa[];

   Physical Surface("Floor") = { floorids[] };

   ids  = Curve{:};
   ids -= idca[];

   Physical Curve("Floor_Bars") = { ids[] };

   Transfinite Curve{ ids[] } = 2 * npx;

   Transfinite Surface{ Surface{:} };
