# Example: Free vibrations of cylindrical fan blade
#
# -------------------------------------------------------------------

  elts   = {"s3", "s4"};     % List of admissible element types
  mtypes = {"consistent", "lumped"};

# Discretization data

  etype = input("Enter element type (s3 or s4): ", "s");
  ne    = input("Enter number of elements in longitudinal direction: ");
  mtype = input("Select mass type: 1 = consistent, 2 = lumped: ");

  if (! ismember(etype, elts))
     error("Element type %s not supported\n", etype);
  end
  if (ne <= 0)
     error("Number of elements must be strictly positive\n");
  end
  if (mtype < 1 || mtype > 2)
     error("Illegal mass type, %d\n", mtype);
  end

# Analysis data

  nofmod = input("Enter number of normal modes: ");
  if (nofmod <= 0)
     error("Number of normal modes must be positive\n");
  end

# Output file

  fid = fopen([etype, ".res"], "wt");

  fprintf(fid, "Discretization: ");
  fprintf(fid, "%d %s elements in one direction, %s mass\n\n",
                ne, etype, mtypes{mtype});

# Model

  mdl = model(ne, etype);

# Analysis

  blade = mfs_new(fid, mdl);
  mfs_export([etype, ".msh"], "msh", blade, "mesh", "mesh", "axes");

  blade = mfs_stiff(blade);
  blade = mfs_mass(blade, mtypes{mtype});
  blade = mfs_freevib(blade, nofmod);

  mfs_print(fid, blade, "modes", "freq");

  mfs_export([etype, ".dsp"], "msh", blade, "modes", "disp");

  mfs_meffmass(fid, blade);

  fclose(fid);
