# Example: Simple glider model
#
# -------------------------------------------------------------------

  fid = fopen("glider.res", "wt");

# Number of normal modes

  nmodes = 20;  % Number of normal modes

# Model definition

  model_definition

# Analysis
# --------

# Create and plot component

  glider = mfs_new(fid, model);
  mfs_export("glider.msh", "msh", glider, "mesh", "mesh", "axes");

# Analysis

  glider = mfs_stiff(glider);
  glider = mfs_mass(glider);
  mfs_massproperties(fid, glider);

  glider = mfs_freevib(glider, nmodes);
  mfs_print(fid, glider, "modes", "freq");
  mfs_export("modes.pos", "msh", glider, "modes", "disp");

  fclose(fid);
