# Example: Simple glider model
#          User-defined rigid degrees of freedom
#
# -------------------------------------------------------------------

  fid = fopen("gliderr.res", "wt");

# Number of normal modes

  nmodes = 20;  % Number of normal modes

# Rigid degrees of freedom

  opts.rdofs = [5, 1; 5, 2; 5, 3; 10, 2; 10, 3; 20, 3];

# Model definition

  model_definition

# Analysis
# --------

# Create and plot component

  glider = mfs_new(fid, model);
  mfs_export("glider.msh", "msh", glider, "mesh", "mesh", "axes");

# Analysis

  glider = mfs_stiff(glider);
  glider = mfs_mass(glider);
  mfs_massproperties(fid, glider);

  glider = mfs_freevib(glider, nmodes, opts);
  mfs_print(fid, glider, "modes", "freq");
  mfs_export("modes.pos", "msh", glider, "modes", "disp");

  fclose(fid);
