# Glider model
#
# ---------------------------------------------------------------

# Data (kg, m)

  c = 7.5;   % Half span
  a = 1.8;   % Length of cabin
  b = 6.8;   % Length of fuselage
  d = 1.0;   % Half span of elevator
  h = 1.3;   % Height of fin
  m =  85;   % Mass of the pilot

  mat = struct("type", "iso", 
               "E", 4E10, "ny", 0.3, "rho", 2000);

# Model definition
# ----------------

  model = struct("type", "solid", "subtype", "3d");

# Cabin nodes

  nodes(1).id =  1; nodes(1).coor = [0, 0, 0];  % Tip
  nodes(2).id =  5; nodes(2).coor = [a, 0, 0];  % Wing Root

  nodes = mfs_linenodes(nodes, 1, 5, 2 : 4);

# Tail nodes

  nodes(6).id = 15; nodes(6).coor = [b, 0, 0];  % End 

  nodes = mfs_linenodes(nodes, 5, 15, 6 : 14);

# Radius and thickness of fuselage

  fuselage.r = [0.2000, 0.3000, 0.4000, 0.4000, 0.3667, ...
                0.2667, 0.1367, 0.1140, 0.1100, 0.1080, ...
                0.1060, 0.1040, 0.1020, 0.1000];
  fuselage.t = [ 0.005,  0.006,  0.006,  0.005,  0.005, ...
                 0.004,  0.003,  0.003,  0.003,  0.003, ...
                 0.003,  0.003,  0.003,  0.003];

# Elements

  for k = 1 : 14
      geom = mfs_beamsection("ring", "thin",
                             fuselage.r(k), fuselage.t(k));
      geom.v = [0, 0, 1];
      elem(k) = struct("id", k, "type", "b2",
                       "nodes", [k, k + 1],
                       "geom", geom, "mat", mat);
  end

# Wings (root is at node 5)

  geom   = mfs_beamsection("box", "thin", 0.6, 0.2, 0.003);
  geom.v = [0, 0, 1];

  nodes(16).id = 30; nodes(16).coor = [a, -c, 0];
  [nodes, ellw] = mfs_line(nodes, 5, 30, 16 : 29, 15 : 29, ...
                           "b2", geom, mat);
  nodes(31).id = 45; nodes(31).coor = [a, c, 0];
  [nodes, elrw] = mfs_line(nodes, 5, 45, 31 : 44, 30 : 44, ...
                           "b2", geom, mat);

  elem = [elem, ellw, elrw];

# Vertical stabilizer (root is at node 15)

  geom  = mfs_beamsection("box", "thin", 0.10, 0.5, 0.003); 
  geom.v = [1, 0, 0];

  nodes(46).id = 47; nodes(46).coor = [b, 0, h];
  [nodes, elfn] = mfs_line(nodes, 15, 47, 46, 45 : 46, ...
                           "b2", geom, mat);

  elem = [elem, elfn];

# Horizontal stabilizer (root is at node 47)

  geom   = mfs_beamsection("box", "thin", 0.5, 0.08, 0.003);
  geom.v = [0, 0, 1];

  nodes(48).id = 49; nodes(48).coor = [b, -d, h];
  nodes(49).id = 51; nodes(49).coor = [b,  d, h];

  [nodes, elle] = mfs_line(nodes, 47, 49, 48, 47 : 48, ...
                           "b2", geom, mat);
  [nodes, elre] = mfs_line(nodes, 47, 51, 50, 49 : 50, ...
                           "b2", geom, mat);

  elem = [elem, elle, elre];

# Pilot

  elem(51).id = 51; elem(51).type = "m1"; elem(51).nodes = 3;
  elem(51).geom.m = m;

# Graphic elements to visualize wing torsion

  nodes(52).id = 52; nodes(52).coor = [a - 0.15, -c, 0];
  nodes(53).id = 53; nodes(53).coor = [a + 0.45, -c, 0];
  nodes(54).id = 54; nodes(54).coor = [a - 0.15,  c, 0];
  nodes(55).id = 55; nodes(55).coor = [a + 0.45,  c, 0];

  elem(52 : 55) = struct("id", {52, 53, 54, 55},
                         "nodes", {[52, 30], [30, 53], ...
                                   [54, 45], [45, 55]},
                         "type", "g2",
                         "geom", [], "mat", []);

  model.nodes    = nodes;
  model.elements = elem;

# Rigid connection of graphic elements

  model.constraints.rigbdy = struct("noda", {30, 45},
                                    "nodd", {[52, 53], [54, 55]},
                                    "dofs", 1 : 3);
