/* ---------------------------------------------------------------
            Stiffened plate with attached point mass
--------------------------------------------------------------- */

// Dimensions [mm]

   DefineConstant [ x4  = 500,   // Length in x-direction
                    y13 = 400,   // Length in y-direction
                    x2  = 100,   // x-position of first stiffener
                    x3  = 300,   // x-position of second stiffener
                    y5  = 100,   // y-position of first stiffener
                    y9  = 300,   // y-position of second stiffener
                    z17 = 100,   // z-position of mass
                    zs  = -10 ]; // z-position of supports

// Meshing parameters

   ne = GetValue("Number of Elements along shortest edge?", 5);
   Mesh.RecombineAll = 1;

// Points of plate and stiffeners

   Point( 1) = { 0,  0,  0};  // Points along y = 0
   Point( 2) = {x2,  0,  0};
   Point( 3) = {x3,  0,  0};
   Point( 4) = {x4,  0,  0};

   Point( 5) = { 0, y5,  0};  // Points aloing y = y5
   Point( 6) = {x2, y5,  0};
   Point( 7) = {x3, y5,  0};
   Point( 8) = {x4, y5,  0};

   Point( 9) = { 0, y9,  0};  // Points along y = y9
   Point(10) = {x2, y9,  0};
   Point(11) = {x3, y9,  0};
   Point(12) = {x4, y9,  0};

   Point(13) = { 0, y13,  0};  // Points along y = y13
   Point(14) = {x2, y13,  0};
   Point(15) = {x3, y13,  0};
   Point(16) = {x4, y13,  0};

// Point of concentrated mass

   Point(17) = {0.3 * x2 + 0.7 * x3, 0.3 * y5 + 0.7 * y9, z17};

// Points of supports

   Point(18) = { 0,   0, zs};  // below Point 1
   Point(19) = {x4,   0, zs};  // below Point 4
   Point(20) = { 0, y13, zs};  // below Point 13
   Point(21) = {x4, y13, zs};  // below Point 16

// Lines 1 to 12: Stiffeners parallel to x-axis

   p1 = 1; lx = 0;
   For m In {0 : 3}
       For n In {0 : 2}
           lx += 1; Line(lx) = {p1++, p1};
       EndFor
       p1++;
   EndFor

// Lines 13 to 24: Stiffeners parallel to y-axis

   ly = lx;
   For m In {0 : 3}
       p1 = 1 + m;
       For n In {0 : 2}
           p2 = p1 + 4;
           ly += 1; Line(ly) = {p1, p2};
           p1 = p2;
       EndFor
   EndFor

   Physical Curve("Stiffeners") = {1 : ly};

   Transfinite Curve {1 : 10 : 3} = ne;
   Transfinite Curve {13 : 22 : 3, 15 : 24 : 3} = ne;
   Transfinite Curve {2 : 11 : 3, 3 : 12 : 3} = 2 * ne;
   Transfinite Curve {14 : 23 : 3} = 2 * ne;

// Concentrated mass at point 17

   Physical Point("Point_Mass") = {17};

// Supports at edge nodes

   Physical Point("Supports") = {18 : 21};

// Rigfit constraint to attach mass

   // Lines to visualize constraint

   P1[0] = 6; P1[1] =  7; P1[2] = 10; P1[3] = 11;
   For k In {0 : 3}
       lno[k] = newl; Line(lno[k]) = {P1[k], 17};
   EndFor

   Physical Curve("Rigfit") = { lno[] };
   Transfinite Curve { lno[] } = 1;

   // Dependent and autonomous nodal points

   Physical Point("Rigfit_d") = 17;
   Physical Point("Rigfit_a") = {6, 7, 10, 11};

// Rigbdy constraints for supports

   // Lines to visualize constraints

   P1 = 18;
   P2[0] = 1; P2[1] = 4; P2[2] = 13; P2[3] = 16;
   For k In {0 : 3}
       lno[k] = newl; Line(lno[k]) = {P1++, P2[k]};
   EndFor

   Physical Curve("Rigbdy") = { lno[] };
   Transfinite Curve { lno[] } = 1;

   // Dependent and autonomous nodal points

   Physical Point("Rbar_1d") =  1;
   Physical Point("Rbar_1a") = 18;
   Physical Point("Rbar_2d") =  4;
   Physical Point("Rbar_2a") = 19;
   Physical Point("Rbar_3d") = 13;
   Physical Point("Rbar_3a") = 20;
   Physical Point("Rbar_4d") = 16;
   Physical Point("Rbar_4a") = 21;

// Surfaces

   lopno  =  1;
   l1 =  1; l2 = 16; l3 =  4; l4 = 13;
 
   For m In {0 : 2}
       l2 = 16 + m; l3 = l1 + 3; l4 = l2 - 3;
       For n In {0 : 2}
           Curve Loop(lopno) = {l1++, l2, -l3, -l4};
           Plane Surface(news) = {lopno++};
           l4 = l2; l2 += 3; l3++;
       EndFor
   EndFor

   Physical Surface("Plate") = {Surface{:}};
   Transfinite Surface {Surface{:}};
