/* ---------------------------------------------------------------
                        Box Beam Structure
--------------------------------------------------------------- */

// Dimensions [mm]

   DefineConstant [ a = 1000,  // Length
                    b =  100,  // Width
                    h =   60]; // Height

// Discretization

   DefineConstant [ na = 50,   // Number of elements in x-direction
                    nb = 7,    // Number of elements in y-direction
                    nc = 5];   // Number of elements in z-direction

   Mesh.ElementOrder = 1;
   Mesh.RecombineAll = 1;
   Mesh.Smoothing    = 1;

// Geometry

   y0 = 0.5 * b;
   z0 = 0.5 * h;

   Point(1) = {0, -y0, -z0};
   Point(2) = {a, -y0, -z0};
   Point(3) = {a,  y0, -z0};
   Point(4) = {0,  y0, -z0};

   Point(5) = {0, -y0,  z0};
   Point(6) = {a, -y0,  z0};
   Point(7) = {a,  y0,  z0};
   Point(8) = {0,  y0,  z0};

   Line(1) = {1, 2};
   Line(2) = {2, 3};
   Line(3) = {3, 4};
   Line(4) = {4, 1};

   Line(5) = {5, 6};
   Line(6) = {6, 7};
   Line(7) = {7, 8};
   Line(8) = {8, 5};

   Line(9) = {1, 5};
   Line(10) = {4, 8};
   Line(11) = {2, 6};
   Line(12) = {3, 7};

   Curve Loop(1) = {1, 2, 3, 4};
   Plane Surface(1) = {1};
   Curve Loop(2) = {5, 6, 7, 8};
   Plane Surface(2) = {2};
   Curve Loop(3) = {1, 11, -5, -9};
   Plane Surface(3) = {3};
   Curve Loop(4) = {3, 10, -7, -12};
   Plane Surface(4) = {4};

// Shell Elements

   Physical Surface("Shell") = {1 : 4};

// Constraints

   Physical Curve("Constraints") = {4, 8, 9, 10};

// Load

   Physical Point("Load") = {7};

// Base motion

   Physical Curve("Motion") = {4, 8, 9, 10};

// Response

   Physical Point("A") = {7};
   Physical Point("B") = {6};

// Structured Mesh

   Transfinite Line{1, 3, 5, 7} = na + 1;
   Transfinite Line{2, 4, 6, 8} = nb + 1;
   Transfinite Line{9 : 12}     = nc + 1;

   Transfinite Surface{1 : 4};
   
