# Example: Box Beam
#          Modal contribution factors
#
# -------------------------------------------------------------------

  colors = [0, 0, 0; 1, 0, 0; 0, 1, 0; 0, 0, 1; 1, 0, 1;
            1, 0.5, 0];
  set(0, "defaultaxescolororder", colors);

  fid  = fopen("mcf.res", "wt");

  freq = 500;
  rid  = {"A", 3; "B", 3};

# Output device depending on operating system

  if (isunix)
     DEVICE = "svg";
  else
     DEVICE = "png";
  endif
  FORMAT = ["-d", DEVICE];
  EXT    = [".", DEVICE];

# Load transfer functions

  load freqresp.bin

# Get modal contribution factors

  res = mfs_modecont(fid, beam, rid, freq, 1 : 2);

# Plot some contribution factors

  pol = res(1, 1).polar(1);
  figure(1, "position", [100, 300, 800, 800],
            "paperposition", [0, 0, 15, 15]);
  polar(pol.theta, pol.rho);
  legend(pol.legend, "location", "northeastoutside");
  title(pol.title);
  print(["mcfA", EXT], FORMAT);

  pol = res(2, 1).polar(1);
  figure(2, "position", [800, 100, 800, 800],
            "paperposition", [0, 0, 15, 15]);
  polar(pol.theta, pol.rho);
  legend(pol.legend, "location", "northeastoutside");
  title(pol.title);
  print(["mcfB", EXT], FORMAT);

  fclose(fid);
