# Example: 2-dimensional truss
#          Restart to print displacements at selected nodal points
#
# -------------------------------------------------------------------

  fb = [55, 85]; % Frequencies for backtransformation

  fid = fopen("restart.res", "wt");

  load truss.bin

# Perform backtransformation

  truss = mfs_back(truss, "freqresp", "disp", 1, fb);
  truss = mfs_back(truss, "freqresp", "disp", 2, fb);

# Print displacements at nodal points 9 to 11

  mfs_print(fid, truss, "freqresp", {"disp", 9 : 11});

  fclose(fid);
