# Example: Instrument panel
#          Frequency response analysis
#
# -------------------------------------------------------------------

  colors = [1, 0, 0; 0, 1, 0; 0, 0, 1];
  set(0, "defaultaxescolororder", colors);

# Output device depending on operating system

  if (isunix)
     DEVICE = "svg";
  else
     DEVICE = "png";
  endif
  FORMAT = ["-d", DEVICE];
  EXT    = [".", DEVICE];

# Results from normal modes analysis

  load modes.bin

# Frequencies

  M = dlmread("Gxx.csv");
  f = M(1, :);

# Frequency response analysis

  for lc = 1 : 4
      panel = mfs_freqresp(panel, f, "nband", 0, "loadcase", lc);
  endfor

# Plot some transfer functions

  rid = {"CM_Altimeter", 1; "CM_AirSpeed",  1;
         "CM_Vario",     1; "CM_Altimeter", 3;
         "CM_AirSpeed",  3; "CM_Vario",     3};

  T1  = mfs_getresp(panel, "freqresp", "acce", rid, 1);
  T2  = mfs_getresp(panel, "freqresp", "acce", rid, 2);

  figure(1, "position", [100, 100, 1000, 500],
            "paperposition", [0, 0, 17, 10]);
  subplot(1, 2, 1)
     plot(f, abs(T1(1 : 3, :)));
     title("Loadcase 1");
     legend("Altimeter", "Air-Speed Indic.", "Variometer",
            "location", "northwest");
     grid;
     xlabel('f [Hz]'); ylabel('a_x / a_x');
  subplot(1, 2, 2); 
     plot(f, abs(T2(1 : 3, :)));
     title("Loadcase 2");
     grid;
     xlabel('f [Hz]'); ylabel('a_x / a_z');
  print(["ax", EXT], FORMAT);

  figure(2, "position", [400, 100, 1000, 500],
            "paperposition", [0, 0, 17, 10]);
  subplot(1, 2, 1)
     plot(f, abs(T1(4 : 6, :)));
     title("Loadcase 1");
     legend("Altimeter", "Air-Speed Indic.", "Variometer",
            "location", "northwest");
     grid;
     xlabel('f [Hz]'); ylabel('a_z / a_x');
  subplot(1, 2, 2); 
     plot(f, abs(T2(4 : 6, :)));
     title("Loadcase 2");
     grid;
     xlabel('f [Hz]'); ylabel('a_z / a_z');
  print(["az", EXT], FORMAT);

# Save results

  save -binary freqresp.bin panel
