/* ------------------------------------------------------------------
                            Instrument Panel
------------------------------------------------------------------ */

// Dimensions [mm]

   DefineConstant [ b = 670,  // Width
                    h = 150,  // Height
                    d = 100]; // Depth

   DefineConstant [ e  =  15,  // Distance from boundary
                    r1 =  40,  // Large radius
                    r2 =  30]; // Small radius

// Discretization

   DefineConstant [ lcb = 20,   // Basic mesh size
                    lcf = 10];  // Fine mesh size

   Mesh.RecombineAll = 1;

// Outer contour of front panel

   yur =  0.5 * b; yul = -yur;
   ylr = 0.45 * b; yll = -ylr;

   Point(1) = {0, yur,  0, lcf}; Point(2) = {0, yul,  0, lcf};
   Point(3) = {0, yll, -h, lcb}; Point(4) = {0, ylr, -h, lcb};

   Line(1) = {1, 2}; Line(2) = {2, 3};
   Line(3) = {3, 4}; Line(4) = {4, 1};

// Outer contour of upper panel

   yrr = 0.45 * b; yrl = -yrr;

   Point(5) = {-d, yrr, 0, lcb}; Point(6) = {-d, yrl, 0, lcb};

   Line(5) = {1, 5}; Line(6) = {5, 6};
   Line(7) = {6, 2}; 

// Bearings

   Point(8) = {0, yur - e, -e, lcf};
   Point(9) = {0, yul + e, -e, lcf};

   Physical Point("Bearings") = {8, 9};

   Physical Point("Right_Ax") = {8};
   Physical Point("Right_Az") = {8};
   Physical Point("Left_Ax")  = {9};
   Physical Point("Left_Az")  = {9};

// Altimeter
   
   ym = -0.25 * b; zm = -0.5 * h;
   Point(10) = {0, ym, zm};
   Point(11) = {0, ym - r1, zm, lcf};
   Point(12) = {0, ym, zm + r1, lcf};
   Point(13) = {0, ym + r1, zm, lcf};
   Point(14) = {0, ym, zm - r1, lcf}; 

   Circle(8)  = {11, 10, 12}; Circle(9)  = {12, 10, 13};
   Circle(10) = {13, 10, 14}; Circle(11) = {14, 10, 11};

   Point(15) = {0, ym + r1, zm + r1, lcf};
   Point(16) = {0, ym - r1, zm + r1, lcf};
   Point(17) = {0, ym - r1, zm - r1, lcf};
   Point(18) = {0, ym + r1, zm - r1, lcf};

   Physical Point("Fix_Altimeter") = {15 : 18};

   Point(19) = {-0.4 * d, ym, zm};

   Physical Point("Altimeter") = {19};
   Physical Point("CM_Altimeter") = {19};

// Air-Speed Indicator
   
   Point(20) = {0, 0, zm};
   Point(21) = {0, -r1, zm, lcf};
   Point(22) = {0, 0, zm + r1, lcf};
   Point(23) = {0, r1, zm, lcf};
   Point(24) = {0, 0, zm - r1, lcf}; 

   Circle(12) = {21, 20, 22}; Circle(13) = {22, 20, 23};
   Circle(14) = {23, 20, 24}; Circle(15) = {24, 20, 21};

   Point(25) = {0,  r1, zm + r1, lcf};
   Point(26) = {0, -r1, zm + r1, lcf};
   Point(27) = {0, -r1, zm - r1, lcf};
   Point(28) = {0,  r1, zm - r1, lcf};

   Physical Point("Fix_AirSpeed") = {25 : 28};

   Point(29) = {-0.4 * d, 0, zm};

   Physical Point("AirSpeed") = {29};
   Physical Point("CM_AirSpeed") = {29};

// Variometer

   ym = 0.25 * b;
   
   Point(30) = {0, ym, zm};
   Point(31) = {0, ym - r2, zm, lcf};
   Point(32) = {0, ym, zm + r2, lcf};
   Point(33) = {0, ym + r2, zm, lcf};
   Point(34) = {0, ym, zm - r2, lcf}; 

   Circle(16) = {31, 30, 32}; Circle(17) = {32, 30, 33};
   Circle(18) = {33, 30, 34}; Circle(19) = {34, 30, 31};

   Point(35) = {0, ym + r2, zm + r2, lcf};
   Point(36) = {0, ym - r2, zm + r2, lcf};
   Point(37) = {0, ym - r2, zm - r2, lcf};
   Point(38) = {0, ym + r2, zm - r2, lcf};

   Physical Point("Fix_Vario") = {35 : 38};

   Point(39) = {-0.3 * d, ym, zm};

   Physical Point("Vario") = {39};
   Physical Point("CM_Vario") = {39};

// Surface of front panel

   Curve Loop(1) = {3, 4, 1, 2};
   Curve Loop(2) = {11, 8, 9, 10};
   Curve Loop(3) = {14, 15, 12, 13};
   Curve Loop(4) = {16, 17, 18, 19};
   Plane Surface(1) = {1, 2, 3, 4};

   Point {8, 9} In Surface {1};
   Point {15 : 18, 25 : 28, 35 : 38} In Surface {1};

// Surface of upper panel

   Curve Loop(5) = {1, -7, -6, -5};
   Plane Surface(2) = {5};

   Physical Surface("Panel") = {1, 2};

// Stiffining beams of front panel

   Physical Curve("Front_Stiffeners") = {2 : 4};

// Stiffining beams of upper panel

   Physical Curve("Upper_Stiffeners") = {5 : 7};

// Annotations

   fontsize = 24;
   fonttype =  4;
   textpos  =  1;
   font = fontsize + 2^8 * fonttype + 2^16 * textpos;

   coorAlti  = Point{19}; coorSpeed = Point{29};
   coorVario = Point{39};

   View "Instruments" {
      T3(coorAlti[0], coorAlti[1], coorAlti[2], font)
         {"Altimeter"};
      T3(coorSpeed[0], coorSpeed[1], coorSpeed[2], font)
         {"Air-Speed Indicator"};
      T3(coorVario[0], coorVario[1], coorVario[2], font)
         {"Variometer"};
   };

  coorRB = Point{8}; coorLB = Point{9};

  View "Bearings" {
     T3(coorRB[0], coorRB[1], coorRB[2], font){"Right Bearing"};
     T3(coorLB[0], coorLB[1], coorLB[2], font){"Left Bearing"};
  };
