/* ---------------------------------------------------------------
                     3-dimensional frame structure                    
--------------------------------------------------------------- */

// Meshing parameters

   lenb = GetValue("Typical Element Length?", 100);

// Points

   Point(1) = {    0, 0,    0, lenb};
   Point(2) = { 1000, 0,    0, lenb};
   Point(3) = { 3000, 0,    0, lenb};
   Point(4) = { 5000, 0,    0, lenb};
   Point(5) = {    0, 0, 1000, lenb};
   Point(6) = { 2000, 0, 1000, lenb};
   Point(7) = { 4000, 0, 1000, lenb};

// Lower Girder

   Line(1) = {1, 2};
   Line(2) = {2, 3};
   Line(3) = {3, 4};

   Physical Line("Lower_Girder") = {1 : 3};

// Upper Girder

   Line(4) = {5, 6};
   Line(5) = {6, 7};

   Physical Line("Upper_Girder") = {4, 5};

// Diagonal Bars

   Line( 6) = {5, 2};
   Line( 7) = {2, 6};
   Line( 8) = {6, 3};
   Line( 9) = {3, 7};
   Line(10) = {7, 4};

   Physical Line("Front_Bars") = {6, 8, 10};
   Physical Line("Rear_Bars")  = {7, 9};

// Constraints

   Physical Point("Constraints") = {1, 5};

// Load

   Physical Point("Load") = {4};

// Annotations

   fontsize = 22;
   fonttype =  4;
   textpos  =  1;
   font = fontsize + 2^8 * fonttype + 2^16 * textpos;

   cA = Point{1};
   cB = Point{5};
   cP = Point{4};

   View "Point Labels" {
      T3(cA[0], cA[1], cA[2], font){ "A" };
      T3(cB[0], cB[1], cB[2], font){ "B" };
      T3(cP[0], cP[1], cP[2], font){ "P" };
   };
