# Example: 3-dimensional frame
#
# ---------------------------------------------------------------

# Data (N, mm)

  E  = 210000; % Young's modulus
  ny =    0.3; % Poisson ratio
  F  =   50E3; % Force

# Output file

  fid = fopen("frame.res", "wt");

# Translation data

  FRAME = struct("type", "solid", "subtype", "3d");

  mat = struct("type", "iso", "E", E, "ny", ny);

  [geom, e] = mfs_beamsection("T", 80, 100, 10);
  geom.v    = [0, 0, 1];
  geom.P    = [0, 50 - e(1)];

  Lower_Girder = struct("type", "elements", "name", "b2",
                        "geom", geom, "mat", mat);

  Upper_Girder        = Lower_Girder;
  Upper_Girder.geom.v = [0, 0, -1];

  FRAME.Lower_Girder = Lower_Girder;
  FRAME.Upper_Girder = Upper_Girder;

  geom   = mfs_beamsection("bar", 50, 10);
  geom.v = [0, 1, 0];
  geom.P = [0, 10];

  Front_Bars = struct("type", "elements", "name", "b2",
                      "geom", geom, "mat", mat);

  Rear_Bars        = Front_Bars;
  Rear_Bars.geom.v = [0, -1, 0];

  FRAME.Front_Bars = Front_Bars;
  FRAME.Rear_Bars  = Rear_Bars;

  FRAME.Constraints = struct("type", "constraints",
                             "name", "prescribed",
                             "dofs", 1 : 6);

  FRAME.Load = struct("type", "loads",
                      "name", "point",
                      "data", [0, 0, -F]);

# Import msh file

  model = mfs_import(fid, "frame.msh", "msh", FRAME);

# Create component

  frame = mfs_new(fid, model);
  mfs_print(fid, frame, "load", "point");
  mfs_export("axes.msh", "msh", frame, "mesh", "axes");

# Analysis

  frame = mfs_stiff(frame);
  frame = mfs_statresp(frame);
  frame = mfs_results(frame, "statresp", "element");

  mfs_print(fid, frame, "statresp", "reac");

# Export results to Gmsh

  mfs_export("frame.pos", "msh", frame,
             "statresp", "disp", "rot", "reac", "resultant");
 
  fclose(fid);
