/* -------------------------------------------------------------------
                          Membrane with a hole
------------------------------------------------------------------- */

// Dimensions [mm]

   DefineConstant [ a = 100,
                    b =  50,
                    r =  20 ];

// Meshing parameters

   np = GetValue("Number of Nodes along Line?", 11);
   p  = GetValue("Progression?", 1.1);

   Mesh.ElementOrder =
   GetValue("Element Order: 1 = Linear, 2 = Quadratic?", 1);
   If (Mesh.ElementOrder == 2)
      Mesh.SecondOrderIncomplete =
      GetValue("Incomplete Order: 0 = no, 1 = yes?", 0);
   EndIf

   Mesh.RecombineAll = 1;
   Mesh.Smoothing = 1;

// Geometry

   Point(1) = {0, 0, 0};
   Point(2) = {r, 0, 0};
   Point(3) = {b, 0, 0};
   Point(4) = {a, 0, 0};
   Point(5) = {a, b, 0};
   Point(6) = {b, b, 0};
   Point(7) = {0, b, 0};
   Point(8) = {0, r, 0};
   Point(9) = {r * Cos(Pi/4), r * Sin(Pi/4), 0};

   Line(1) = {2, 3};
   Line(2) = {3, 4};
   Line(3) = {4, 5};
   Line(4) = {5, 6};
   Line(5) = {6, 7};
   Line(6) = {8, 7};
   Line(7) = {3, 6};
   Line(8) = {9, 6};

   Circle( 9) = {8, 1, 9};
   Circle(10) = {9, 1, 2};

   Line Loop(1) = {1, 7, -8, 10};
   Line Loop(2) = {2, 3, 4, -7};
   Line Loop(3) = {8, 5, -6, 9};

   Plane Surface(1) = {1};
   Plane Surface(2) = {2};
   Plane Surface(3) = {3};

   Physical Surface("Membrane") = {1, 2, 3};

   Physical Line("Symmetry_x") = {6};
   Physical Line("Symmetry_y") = {1, 2};
   Physical Line("Right_Constraint") = {3};
   Physical Line("Right_Load") = {3};

   Physical Line("Hole") = {9, 10};

// Meshing commands

   Transfinite Line{1, 6, 8} = np Using Progression p;
   Transfinite Line{2 : 5, 7, 9, 10} = np;

   Transfinite Surface{1 : 3};
