# Example 3: Membrane with hole
#            Elements with drilling dofs
#
# ----------------------------------------------------------------

  opts.chkelts = 1;

# Data (N, mm)

  E  = 210000;    % Youngs's modulus
  ny =    0.3;    % Poisson ratio
  t  =      5;    % Thickness
  u  =    0.1;    % Prescribed displacement

  name = "q4r";

# Output file

  fid = fopen("holer.res", "wt");

# Translation data

  HOLE = struct("type", "solid", "subtype", "2d");

  geom = struct("t", t);
  mat  = struct("type", "iso", "E", E, "ny", ny);

  HOLE.Membrane = struct("type", "elements",
                         "name", name,
                         "geom", geom,
                         "mat",  mat);

  HOLE.Symmetry_x = struct("type", "constraints",
                           "name", "prescribed",
                           "dofs", [1, 3]);

  HOLE.Symmetry_y = struct("type", "constraints",
                           "name", "prescribed",
                           "dofs", 2 : 3);

  HOLE.Right_Constraint = struct("type", "constraints",
                                 "name", "prescribed",
                                 "dofs", 1);

  HOLE.Right_Load = struct("type", "loads",
                           "name", "disp",
                           "data", u);

  HOLE.Hole = struct("type", "nodeset");

# Import msh file

  model = mfs_import(fid, "hole.msh", "msh", HOLE);

# Create component

  hole = mfs_new(fid, model, opts);
  mfs_print(fid, hole, "load", "disp");

# Analysis

  hole = mfs_stiff(hole);
  hole = mfs_statresp(hole);
  hole = mfs_results(hole, "statresp", "element");

  mfs_print(fid, hole, "statresp", "reac");
  mfs_print(fid, hole, "statresp", {"disp", "Hole"});

# Export results go Gmsh

  mfs_export("holer.pos", "msh", hole,
             "statresp", "disp", "reac", "stress");

  fclose(fid);
