/* -------------------------------------------------------------------
                                T-Junction
------------------------------------------------------------------- */

// Dimensions [mm]

   DefineConstant [ B =  50,
                    b =  10,
                    H =  60,
                    h =  20,
                    r =   5, 
                    R =   2 ];

// Meshing parameters

   nelb = GetValue("Number of Elements along Width?", 50);
   es = 2 * B / nelb;
   ef = 0.5 * es;
   Mesh.ElementOrder = 
   GetValue("Element Order: 1 = Linear, 2 = Quadratic?", 1);
   If (Mesh.ElementOrder == 2)
      Mesh.SecondOrderIncomplete = 
      GetValue("Incomplete Order: 0 = no, 1 = yes?", 0);
   EndIf
   Mesh.RecombineAll =
   GetValue("Create Quadrangles: 0 = no, 1 = yes?", 1);

   Mesh.Smoothing = 5;

// Geometry: Outer Contour

   Point( 1) = {-B, 0, 0, es};
   Point( 2) = { B, 0, 0, es};
   Point( 3) = { B, h, 0, es};
   Point( 4) = { b + r, h, 0, es};
   Point( 5) = { b, h + r, 0, es};
   Point( 6) = { b, H, 0, es};
   Point( 7) = {-b, H, 0, es};
   Point( 8) = {-b, h + r, 0, es};
   Point( 9) = {-b - r, h, 0, es};
   Point(10) = {-B, h, 0, es};

   Point(11) = {-b - r, h + r, 0};  // Center of left circle 
   Point(12) = { b + r, h + r, 0};  // Center of right circle 

   Line(1) = {1, 2};
   Line(2) = {2, 3};
   Line(3) = {3, 4};

   Circle(4) = {4, 12, 5};

   Line(5) = {5, 6};
   Line(6) = {6, 7};
   Line(7) = {7, 8};

   Circle(8) = {8, 11, 9};

   Line(9) = {9, 10};
   Line(10) = {10, 1};

   Line Loop(1) = {1 : 10};

// Geometry: Holes

   Point(13) = {-B + 3 * R, h/2, 0};
   Point(14) = {-B + 2 * R, h/2, 0, ef};
   Point(15) = {-B + 4 * R, h/2, 0, ef};

   Circle(11) = {15, 13, 14};
   Circle(12) = {14, 13, 15};

   Line Loop(2) = {11, 12};

   Point(16) = {B - 3 * R, h/2, 0};
   Point(17) = {B - 2 * R, h/2, 0, ef};
   Point(18) = {B - 4 * R, h/2, 0, ef};

   Circle(13) = {18, 16, 17};
   Circle(14) = {17, 16, 18};

   Line Loop(3) = {13, 14};

   Point(19) = {0, H - 3 * R, 0};
   Point(20) = {R, H - 3 * R, 0, ef};
   Point(21) = {-R, H - 3 * R, 0, ef};

   Circle(15) = {20, 19, 21};
   Circle(16) = {21, 19, 20};

   Line Loop(4) = {15, 16};

// Geometry: Surface

   Plane Surface(1) = {1, 2, 3, 4};
   Physical Surface ("Junction") = {1};

// Constraints

   Physical Line("Constraints") = {11 : 16};
   Physical Point("DrillingDof") = {1};

// Load

   Physical Line("Load") = {15, 16};

// Annotations

   fontsize = 14;
   fonttype =  4;
   textpos  =  1;
   font = fontsize + 2^8 * fonttype + 2^16 * textpos;

   cA = Point{13};
   cB = Point{16};
   cC = Point{19};

   View "Point Labels" {
      T3(cA[0], cA[1], cA[2], font){ "A" };
      T3(cB[0], cB[1], cB[2], font){ "B" };
      T3(cC[0], cC[1], cC[2], font){ "C" };
   };
