# Example: 2-dimensional T-junction
#          Elements with drilling dofs
#
# --------------------------------------------------------------------

# Data (N, mm)

  E  = 210000; % Young's modulus
  ny =    0.3; % Poisson ratio
  t  =      2; % Thickness
  u  =    0.1; % Prescribed displacement of upper hole

  name = {"2 = t3r", "3 = q4r"};

# Output file

  fid = fopen("junctionr.res", "wt");

# Translation data

  td = struct("type", "solid", "subtype", "2d");

  geom = struct("t", t);
  mat  = struct("type", "iso", "E", E, "ny", ny);

  td.Junction = struct("type", "elements",
                       "name", {name},
                       "geom", geom,
                       "mat",  mat);

  td.Constraints = struct("type", "constraints",
                          "name", "prescribed",
                          "dofs", [1, 2]);

  td.Load = struct("type", "loads",
                   "name", "disp",
                   "data", [u, 0]);

  td.DrillingDof = struct("type", "constraints",
                          "name", "prescribed",
                          "dofs", 3);

# Import msh file

  model = mfs_import(fid, "junction.msh", "msh", td);

# Create component

  junction = mfs_new(fid, model);

# Analysis

  junction = mfs_stiff(junction);
  junction = mfs_statresp(junction);
  junction = mfs_results(junction, "statresp", "element");

  mfs_print(fid, junction, "statresp", "reac");

# Export results to Gmsh

  mfs_export("junctionr.pos", "msh", junction,
             "statresp", "disp", "reac", "stress");

  fclose(fid);
