# Example: Scordelis-Lo roof
#
# Compare convergence history
#
# -------------------------------------------------------------------

# Get data

  s3 = dlmread("s3.csv");
  s4 = dlmread("s4.csv");

# Plot data

  figure(1, "position", [100, 100, 800, 500],
            "paperposition", [0, 0, 15, 10]);
  plot(s3(:, 1), s3(:, 2), "color", "blue", "marker", "^",
       s4(:, 1), s4(:, 2), "color", "red", "marker", "s");
  legend("s3", "s4", "location", "east");
  grid;
  xlabel('Number of intervals');
  ylabel('w_G/w_{Gref}');

  print("history.svg", "-dsvg");
