# Example: 3-dimensional truss
#
# ---------------------------------------------------------------

# Data

  a =     800;  % Length in mm
  b =     600;  % Length in mm 
  Gy =  -3000;  % Force in N
  Gz =  -6000;  % Force in N
  E =   2.1E6;  % Young's modulus in MPa
  A =      25;  % Cross section area in mm^2

# Output file

  fid = fopen("truss.res", "wt");

# Model definition

  model = struct("type", "solid", "subtype", "3d");

  nodes(1).id = 1; nodes(1).coor = [     0  -b, 0];  % A
  nodes(2).id = 2; nodes(2).coor = [     0,  0, 0];  % B
  nodes(3).id = 3; nodes(3).coor = [     0,  0, b];  % C
  nodes(4).id = 4; nodes(4).coor = [     a, -b, 0];  % D
  nodes(5).id = 5; nodes(5).coor = [     a,  0, 0];  % E
  nodes(6).id = 6; nodes(6).coor = [     a,  0, b];  % F
  nodes(7).id = 7; nodes(7).coor = [ 2 * a,  0, 0];  % G

  model.nodes = nodes;

  elem( 1).id =  1; elem( 1).nodes = [1, 4]; % AD
  elem( 2).id =  2; elem( 2).nodes = [2, 4]; % BD
  elem( 3).id =  3; elem( 3).nodes = [2, 5]; % BE
  elem( 4).id =  4; elem( 4).nodes = [2, 6]; % BF
  elem( 5).id =  5; elem( 5).nodes = [3, 4]; % CD
  elem( 6).id =  6; elem( 6).nodes = [3, 6]; % CF
  elem( 7).id =  7; elem( 7).nodes = [4, 5]; % DE
  elem( 8).id =  8; elem( 8).nodes = [4, 6]; % DF
  elem( 9).id =  9; elem( 9).nodes = [4, 7]; % DG
  elem(10).id = 10; elem(10).nodes = [5, 6]; % EF
  elem(11).id = 11; elem(11).nodes = [5, 7]; % EG
  elem(12).id = 12; elem(12).nodes = [6, 7]; % FG

  geom = struct("A",  A);
  mat  = struct("type", "iso", "E", E);

  for k = 1 : length(elem)
      elem(k).type = "r2";
      elem(k).geom = geom;
      elem(k).mat  = mat;
  end

  model.elements = elem;

  hinge = struct("id", {1, 2, 3}, "dofs", 1 : 3);
  model.constraints.prescribed = hinge;

  force = struct("id", 7, "data", [0, Gy, Gz]);
  model.loads.point = force;

# Analysis

  truss = mfs_new(fid, model);
  mfs_export("truss.msh", "msh", truss, "mesh");

  truss = mfs_stiff(truss);
  truss = mfs_statresp(truss);
  truss = mfs_results(truss, "statresp", "element");

  mfs_print(fid, truss, "statresp", "disp", "reac", "resultant");

  mfs_export("truss.pos", "msh", truss, "statresp", "disp", "resultant");

  fclose(fid);
