# Example: Box Beam
#          Comparison of results from transient and frequency
#          response analysis
#
# -------------------------------------------------------------------

  colors = [1, 0, 0; 0, 1, 0; 0, 0, 1];
  set(0, "defaultaxescolororder", colors);

  resp     = {"u_", "v_", "a_"};
  units    = {"[mm]", "[m/s]", "[g]"};
  locs     = {"southeast", "northeast", "northeast"};
  pltfiles = {"cmp_tf_u.svg", "cmp_tf_v.svg", "cmp_tf_a.svg"};

  nfig = 1;

  if (isfile("tresp.csv") && isfile("fresp.csv"))

     rt = dlmread("tresp.csv");
     rf = dlmread("fresp.csv");

     tt = rt(1, :);
     tf = rf(1, :);
     Ts = min(tt(end), tf(end));
     
     row  =   2;
     xpos = 100;

     for m = 1 : 3

        figure(nfig++, "position", [xpos, 100, 1000, 800],
                       "paperposition", [0, 0, 15, 12]);
        subplot(2, 1, 1)
           plot(tt, rt(row, :), tf, rf(row++, :));
           legend("trans.", "freq.", "location", locs{m});
           grid;
           axis("labely");
           xlim([0, Ts]);
           ylabel([resp{m}, "A ", units{m}]);
        subplot(2, 1, 2)
           plot(tt, rt(row, :), tf, rf(row++, :));
           grid;
           xlim([0, Ts]);
           ylabel([resp{m}, "B ", units{m}]);
           xlabel('t [s]');

        print(pltfiles{m}, "-dsvg");

        xpos += 200;

     end

  else

     printf("Either file tresp.csv of file fresp.csv do not exist\n");

  end
