function y = motion(t, T)

# Input  t(:)     Array with time steps
#        T        Duration of motion
#
# Output y(1, :)  Displacements
#        y(2, :)  Velocities
#        y(3, :)  Accelerations
#
# Structure moves to upper position.
#
# ---------------------------------------------------------

  n  = length(t);
  y  = zeros(3, n);

  ix = find(t <= T); nx = ix(end);
  tx = t(ix) / T;
  s = sin(2 * pi * tx); c = cos(2 * pi * tx);

  y(1, ix) = tx - s / (2 * pi); y(1, nx + 1 : n) = 1;
  y(2, ix) = (1 - c) / T;
  y(3, ix) = 2 * pi * s / T^2;

endfunction
