# Example: Plate
#          Comparison of results
#
# -------------------------------------------------------------------

  colors = [1, 0, 0; 0, 1, 0; 0, 0, 1];
  set(0, "defaultaxescolororder", colors);

  resp = {"w_", "v_", "a_"};
  units = {"[mm]", "[m/s]", "[g]"};

# Output device depending on operating system

  if (isunix)
     DEVICE = "svg";
  else
     DEVICE = "png";
  endif
  FORMAT = ["-d", DEVICE];
  EXT    = [".", DEVICE];

# Possible Options and corresponding legends

  allopts =  {"Impact: Direct versus Modal",
              "Impact: Transient versus Frequency Response",
              "Decay: Direct versus Modal"};

  legtxt = {{"dir.", "mod."}, {"trans.", "freq."}};
  legidx = [1, 2, 1];

# File names

  infiles = {{"impact_direct.csv", "impact_modal.csv"},
             {"impact_modal.csv", "impact_fresp.csv"},
             {"decay_direct.csv", "decay_modal.csv"}};

  pltfiles = {{["impact_compare_dm_w", EXT], ...
               ["impact_compare_dm_v", EXT], ...
               ["impact_compare_dm_a", EXT]},
              {["impact_compare_tf_w", EXT], ...
               ["impact_compare_tf_v", EXT], ...
               ["impact_compare_tf_a", EXT]},
              {["decay_compare_dm_w", EXT], ...
               ["decay_compare_dm_v", EXT], ...
               ["decay_compare_dm_a", EXT]}};

# Check what comparisons are possible

  for n = 1 : 3
      files_found(n) = isfile(infiles{n}{1}) && isfile(infiles{n}{2});
  end

# Build list of comparisons that are possible

  ixp  = find(files_found);
  opts = allopts(ixp);

  [sel, ok] = listdlg("Name", "Select diagrams to be generated",
                      "ListString", opts,
                      "ListSize", [500, 100]);

  if (! ok) return; end

# Compare selected results

  nfig =   1;
  ypos = 100;

  for n = 1 : length(sel)

      ix = ixp(sel(n));

      r1 = dlmread(infiles{ix}{1});
      r2 = dlmread(infiles{ix}{2});

      t1 = r1(1, :);
      t2 = r2(1, :);
      Ts = min(t1(end), t2(end));
         
      row  =   2;
      xpos = 200;
      legs = legtxt{legidx(ix)};

      for m = 1 : 3

          figure(nfig++, "position", [xpos, ypos, 1000, 800],
                         "paperposition", [0, 0, 15, 15]);
          subplot(3, 1, 1)
             plot(t1, r1(row, :), t2, r2(row++, :)); 
             legend(legs, "location", "northeastoutside");
             grid;
             axis("labely");
             xlim([0, Ts]);
             ylabel([resp{m}, "A ", units{m}]);
          subplot(3, 1, 2)
             plot(t1, r1(row, :), t2, r2(row++, :)); 
             grid;
             axis("labely");
             xlim([0, Ts]);
             ylabel([resp{m}, "B ", units{m}]);
          subplot(3, 1, 3)
             plot(t1, r1(row, :), t2, r2(row++, :)); 
             grid;
             xlim([0, Ts]);
             ylabel([resp{m}, "C ", units{m}]);
             xlabel('t [s]');

          print(pltfiles{ix}{m}, FORMAT);

          xpos += 200;

      end

      ypos += 50;

  end
