function y = decay(t, params)
  
# Input  t(:)       Array with time steps
#        params(1)  (1) Duration of decay
#
# Output y(:)       Time history
#
# ---------------------------------------------------------

  n = length(t);
  y = zeros(1, n);

  T  = params(1); 
  ix = find(t <= T);
  w  = pi / (2 * T);
  y(ix) = cos(w * t(ix)).^2;

end

