# Example: Plate
#          Normal modes and error estimation
#
# ----------------------------------------------------------------

  fid = fopen("modes.res", "wt");

# Define simulation paramters

  nofmod =  20;  % Number of normal modes
  fmax   = 450;  % Maximum excitation frequency

# Define model

  PLATE = plate_model();
  model = mfs_import(fid, "plate.msh", "msh", PLATE);

# Create component and export axes

  plate = mfs_new(fid, model);
  mfs_export("plate.axes", "msh", plate, "mesh", "axes");

# Compute normal modes

  plate = mfs_stiff(plate);
  plate = mfs_mass(plate);

  mfs_massproperties(fid, plate);

  plate = mfs_freevib(plate, nofmod);
  mfs_print(fid, plate, "modes", "freq");
  mfs_export("modes.dsp", "msh", plate, "modes", "disp");

# Estimate reduction error

  mfs_reductionerror(fid, plate, fmax);

# Save results

  save -binary modes.bin plate

  fclose(fid);
