/* ---------------------------------------------------------------
                                  Plate
--------------------------------------------------------------- */

// Dimensions

  DefineConstant [ h1 = 300,
                   h2 = 200,
                   b1 = 200,
                   b2 = 200,
                   s1 =  60,
                   s2 =  40 ];

  DefineConstant [ xA =  80, yA =  80,
                   xB = 200, yB = 200,
                   xC = 320, yC = 140 ];

// Meshing parameters

  elen = GetValue("Element Size?", b1 / 20);

  Mesh.RecombineAll = 1; Mesh.Smoothing = 1;

// Geometry

  Point(1) = {0, 0, 0, elen};
  Point(2) = {0, h1, 0, elen};
  Point(3) = {b1, h1, 0, elen};
  Point(4) = {b1, h1 - s2, 0, elen};
  Point(5) = {b1 + b2, h1 - s2, 0, elen};
  Point(6) = {b1 + b2, s1, 0, elen};
  Point(7) = {b1, s1, 0, elen};
  Point(8) = {b1, 0, 0, elen};

  Point( 9) = {xA, yA, 0, elen};  // Point A
  Point(10) = {xB, yB, 0, elen};  // Point B
  Point(11) = {xC, yC, 0, elen};  // Point C

  Line(1) = {1, 2};
  Line(2) = {2, 3};
  Line(3) = {3, 4};
  Line(4) = {4, 5};
  Line(5) = {5, 6};
  Line(6) = {6, 7};
  Line(7) = {7, 8};
  Line(8) = {8, 1};

  Curve Loop(1) = {1, 2, 3, 4, 5, 6, 7, 8};
  Plane Surface(1) = {1};

  Point {9 : 11} In Surface {1};

// Shell elements

  Physical Surface("Plate") = {1};

// Constraints

  Physical Curve("Constraints") = {2, 5, 8};

// Points with loads

  Physical Point("Load_A") = { 9};
  Physical Point("Load_B") = {10};
  Physical Point("Load_C") = {11};

// Points for response

  Physical Point("Resp_A") = { 9};
  Physical Point("Resp_B") = {10};
  Physical Point("Resp_C") = {11};

// Mark Points A to C

  fontsize = 24;
  fonttype =  4;
  textpos  =  1;
  font = fontsize + 2^8 * fonttype + 2^16 * textpos;

  A = Point{9}; B = Point{10}; C = Point{11};

  View "Points" {
     T3(A[0], A[1], A[2], font){ "A" };
     T3(B[0], B[1], B[2], font){ "B" };
     T3(C[0], C[1], C[2], font){ "C" };
  };
