function PLATE = plate_model()

# Example: Plate
#          Model definition
#
# ----------------------------------------------------------------

# Data (N, mm):

  E   =  210000;  % Young's modulus
  ny  =     0.3;  % Poisson's ratio
  rho = 7.85E-9;  % Mass density
  t   =       2;  % Thickness

  FA  =      25;  % Amplitude of load at point A
  FB  =      40;  % Amplitude of load at point B
  FC  =      50;  % Amplitude of load at point C

  aK  =    2e-5;  % Parameter for Rayleigh-damping
  aM  =      20;  % Parameter for Rayleigh-damping

# Material data

  mat = struct("type", "iso", "E", E, "ny", ny, "rho", rho);

# Model type and subtype

  PLATE = struct("type", "solid", "subtype", "3d");

# Shell elements

  geom = struct("t", t);

  PLATE.Plate = struct("type", "elements", "name", "s4",
                       "geom", geom, "mat", mat);

# Constraints

  PLATE.Constraints = struct("type", "constraints",
                             "name", "prescribed",
                             "dofs", [1 : 3, 6]);

# Damping

  PLATE.damping = struct("type", "Rayleigh",
                         "data", [aK, aM]);

# Point loads

  PLATE.Load_A = struct("type", "loads", "name", "point",
                        "data", [0, 0, -FA], "lc", 1);
  PLATE.Load_B = struct("type", "loads", "name", "point",
                        "data", [0, 0, -FB], "lc", 2);
  PLATE.Load_C = struct("type", "loads", "name", "point",
                        "data", [0, 0, -FC], "lc", 3);

# Response points

  PLATE.Resp_A.type = "nodeset";
  PLATE.Resp_B.type = "nodeset";
  PLATE.Resp_C.type = "nodeset";

end
