function y = pulse(t, params)

# Input  t(:)       Array with time steps
#        params(2)  (1) Duration of pulse
#                   (2) Time delay
#
# Output y(:)       Time history
#
# ---------------------------------------------------------

  n = length(t);
  y = zeros(1, n);

  T = params(1); delay = params(2);

  ix = find(t >= delay & t <= T + delay);
  w  = pi / T;
  y(ix) = sin(w * (t(ix) - delay));

end
